/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.websm.profile;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.websm.cec.CECInfo;
import com.ibm.hsc.websm.lpar.LPARInfo;
import com.ibm.hsc.websm.lpar.LPARMObject;
import com.ibm.hsc.websm.profile.ProfileInfo;
import com.ibm.websm.diagnostics.Diag;
import com.ibm.websm.diagnostics.IDebug;
import com.ibm.websm.etc.EWorkingListener;
import com.ibm.websm.etc.StringVector;
import com.ibm.websm.mobject.DefSysEventSupport;
import com.ibm.websm.mobject.MOClass;
import com.ibm.websm.mobject.MOClassImpl;
import com.ibm.websm.mobject.MORelationship;
import com.ibm.websm.mobject.MORelationshipImpl;
import com.ibm.websm.mobject.MOState;
import com.ibm.websm.mobject.MOXContainerObj;
import com.ibm.websm.mobject.MOXReference;
import com.ibm.websm.mobject.MObjectImpl;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMObjectPath;

public class ProfileMObject
extends MObjectImpl {
    private String _name = null;
    private MOState _mostate = null;
    private String _bootMode = null;
    private int _rawBootMode = 0;
    private short _rmoSize = 0;
    private Boolean _isDefaultProfile = null;
    private String _state = null;
    private String _opPanelValue = "";
    private CIMObjectPath _cimObjectPath;
    private static StringVector _relationshipNameList = null;

    public ProfileMObject(String string) throws Throwable {
        try {
            this.setKey(string);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.profile.ProfileMObject");
        String[] stringArray = new String[]{"name", "cimObjectPath_PROP", "state_PROP"};
        Hashtable hashtable = ProfileInfo.getProfileAttribute(stringArray, mOClassImpl.getHost().getName(), this.getKey());
        this._name = (String)hashtable.get("name");
        this._cimObjectPath = (CIMObjectPath)hashtable.get("cimObjectPath_PROP");
        this._state = (String)hashtable.get("state_PROP");
        this._isDefaultProfile = (Boolean)hashtable.get("isDefaultProfile_PROP");
        this._mostate = ProfileMObject._createProfileMOState(null, this.getName(), this._isDefaultProfile);
    }

    public ProfileMObject(String string, Hashtable hashtable) throws Throwable {
        this.setKey(string);
        if (hashtable != null) {
            this._name = (String)hashtable.get("name");
            this._mostate = (MOState)hashtable.get("MOState");
            this._state = (String)hashtable.get("state_PROP");
            this._cimObjectPath = (CIMObjectPath)hashtable.get("cimObjectPath_PROP");
            this._isDefaultProfile = (Boolean)hashtable.get("isDefaultProfile_PROP");
        }
    }

    public static MObjectImpl getInstance(MOXReference mOXReference) throws Throwable {
        String string = mOXReference.getKey();
        ProfileMObject profileMObject = new ProfileMObject(string);
        return profileMObject;
    }

    public static MObjectImpl createNewInstance(Hashtable hashtable) throws Throwable {
        String string = (String)hashtable.get("Name");
        hashtable.put("MOState", ProfileMObject._createProfileMOState(null, string, (Boolean)hashtable.get("isDefaultProfile_PROP")));
        ProfileMObject profileMObject = new ProfileMObject(string, hashtable);
        MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.profile.ProfileMObject");
        DefSysEventSupport defSysEventSupport = (DefSysEventSupport)mOClassImpl.getEventSupport();
        if (defSysEventSupport != null) {
            defSysEventSupport.fireMOEvent(string, "OAE", (Object)profileMObject.getMOState(), hashtable);
        }
        return profileMObject;
    }

    public Hashtable getPropertyValues(String[] stringArray, String string, Object object) throws Throwable {
        if (stringArray != null) {
            return super.getPropertyValues(stringArray, string, object);
        }
        MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.profile.ProfileMObject");
        Hashtable hashtable = null;
        try {
            hashtable = ProfileInfo.getProfileAttribute(stringArray, mOClassImpl.getHost().getName(), this.getKey());
        }
        catch (Exception exception) {
            if (IDebug.enabled()) {
                exception.printStackTrace();
            }
            return null;
        }
        this._name = (String)hashtable.get("name");
        this._cimObjectPath = (CIMObjectPath)hashtable.get("cimObjectPath_PROP");
        return hashtable;
    }

    public void setPropertyValues(Hashtable hashtable, String string, EWorkingListener eWorkingListener) throws Throwable {
        MOState mOState;
        if (eWorkingListener != null) {
            eWorkingListener.showDialog(true);
        }
        Boolean bl = (Boolean)hashtable.get("updateCimom_PROP");
        DefSysEventSupport defSysEventSupport = (DefSysEventSupport)this.getMOClassImpl().getEventSupport();
        DefSysEventSupport defSysEventSupport2 = (DefSysEventSupport)this.getEventSupport();
        MOState mOState2 = (MOState)hashtable.get("MOState");
        Boolean bl2 = (Boolean)hashtable.get("isDefaultProfile_PROP");
        String string2 = (String)hashtable.get("name");
        Short s = (Short)hashtable.get("rmoSize_PROP");
        if (bl2 != null) {
            this._isDefaultProfile = bl2;
            this._notifyPropChangeListeners(defSysEventSupport, defSysEventSupport2, "isDefaultProfile_PROP", bl2);
            if (mOState2 == null) {
                this._mostate = mOState = ProfileMObject._createProfileMOState(null, this.getKey(), bl2);
                this._notifyPropChangeListeners(defSysEventSupport, defSysEventSupport2, "MOState", mOState);
            }
        }
        if (mOState2 != null) {
            this._mostate = mOState2;
            this._notifyPropChangeListeners(defSysEventSupport, defSysEventSupport2, "MOState", mOState2);
        }
        if (string2 != null) {
            this._name = string2;
            this._notifyPropChangeListeners(defSysEventSupport, defSysEventSupport2, "name", string2);
            mOState = new String[2];
            String string3 = null;
            mOState[0] = "name";
            mOState[1] = this._name;
            String string4 = HSCLogUtils.getUserName((MOClass)MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.profile.ProfileMObject"));
            string3 = MessageFormat.format(HSCResourceBundleUtil.getMessage("HSCCommonBundle", "PROPERTY_CHANGED"), "name", this._name);
            HSCLogUtils.logSystemEvent((short)2048, string3, (String[])mOState, string4);
        }
        if (s != null) {
            this._rmoSize = s;
            this._notifyPropChangeListeners(defSysEventSupport, defSysEventSupport2, "rmoSize_PROP", s);
        }
        if (eWorkingListener != null) {
            eWorkingListener.eof(0);
            eWorkingListener.showDialog(false);
        }
    }

    public static Hashtable getChildren(Vector vector, String string) throws Throwable {
        Hashtable<MOXReference, Vector> hashtable;
        block5: {
            block4: {
                hashtable = new Hashtable<MOXReference, Vector>();
                if (!string.equals("parent_child")) break block4;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    MOXReference mOXReference = (MOXReference)enumeration.nextElement();
                    hashtable.put(mOXReference, new Vector());
                }
                break block5;
            }
            if (!string.equals("child_parent")) break block5;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                MOXReference mOXReference = (MOXReference)enumeration.nextElement();
                try {
                    Vector vector2 = LPARMObject.getParentsOfProfile(mOXReference.getKey());
                    if (vector2 == null) continue;
                    hashtable.put(mOXReference, vector2);
                }
                catch (Throwable throwable) {
                    Diag.handleException((Throwable)throwable);
                }
            }
        }
        return hashtable;
    }

    public static StringVector getRelationshipNameList() throws Throwable {
        if (_relationshipNameList == null) {
            _relationshipNameList = new StringVector();
            _relationshipNameList.addElement("parent_child");
            _relationshipNameList.addElement("child_parent");
        }
        return _relationshipNameList;
    }

    public MORelationship getRelationship(String string) {
        if (string.equals("parent_child")) {
            return null;
        }
        return this._getLPARForProfile();
    }

    public static Hashtable getProfileInst(String string, CIMObjectPath cIMObjectPath) throws Throwable {
        Hashtable hashtable = null;
        try {
            hashtable = ProfileInfo.getProfileInst(string, cIMObjectPath);
        }
        catch (Throwable throwable) {
            System.out.println("Error while getting profile instance.");
            throw throwable;
        }
        return hashtable;
    }

    public static String getInverseRelationshipName(String string) {
        if (string.equals("parent_child")) {
            return "child_parent";
        }
        if (string.equals("child_parent")) {
            return "parent_child";
        }
        return null;
    }

    public static Vector getProfilesForPartition(String string) throws Throwable {
        Hashtable hashtable;
        MOXContainerObj mOXContainerObj;
        Cloneable cloneable;
        MOClass mOClass = MObjectImpl.getMOClassProxy((String)"com.ibm.hsc.websm.profile.ProfileMObject");
        Vector<MOXContainerObj> vector = new Vector<MOXContainerObj>();
        Hashtable hashtable2 = ProfileInfo.getProfileInfo(mOClass.getHost().getName(), string);
        if (hashtable2 != null) {
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                cloneable = (Hashtable)hashtable2.get(string2);
                String string3 = (String)hashtable2.get("name");
                mOXContainerObj = new MOXReference(mOClass, string2, (Hashtable)cloneable);
                hashtable = ProfileMObject._createProfileMOState(null, string2, (Boolean)((Hashtable)cloneable).get("isDefaultProfile_PROP"));
                vector.addElement(new MOXContainerObj((MOXReference)mOXContainerObj, string3, (MOState)hashtable));
            }
        }
        int n = vector.size();
        boolean bl = false;
        cloneable = new Vector(1);
        int n2 = 0;
        while (n2 < n) {
            Boolean bl2;
            mOXContainerObj = (MOXContainerObj)vector.elementAt(n2);
            hashtable = (Hashtable)hashtable2.get(mOXContainerObj.getKey());
            if (hashtable != null && (bl2 = (Boolean)hashtable.get("isDefaultProfile_PROP")) != null && bl2.booleanValue()) {
                ((Vector)cloneable).add(0, mOXContainerObj);
                bl = true;
                vector.removeElement(mOXContainerObj);
                vector.trimToSize();
                break;
            }
            ++n2;
        }
        if (bl) {
            ((Vector)cloneable).addAll(1, vector);
            return cloneable;
        }
        return vector;
    }

    public static Vector getContainerObjList(String[] stringArray, Object object) throws Throwable {
        MOClass mOClass = MObjectImpl.getMOClassProxy((String)"com.ibm.hsc.websm.profile.ProfileMObject");
        Vector<MOXContainerObj> vector = new Vector<MOXContainerObj>();
        Hashtable hashtable = ProfileInfo.getProfileInfo(mOClass.getHost().getName(), null);
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Hashtable hashtable2 = (Hashtable)hashtable.get(string);
                String string2 = (String)hashtable.get("name");
                MOXReference mOXReference = new MOXReference(mOClass, string, hashtable2);
                MOState mOState = ProfileMObject._createProfileMOState(null, string, (Boolean)hashtable2.get("isDefaultProfile_PROP"));
                vector.addElement(new MOXContainerObj(mOXReference, string2, mOState));
            }
        }
        return vector;
    }

    public static String getPropertyExposeSuffix() {
        return new String("_PROP");
    }

    public String getName() {
        return this._name;
    }

    public MOState getMOState() {
        return this._mostate;
    }

    public String getBootMode_PROP() {
        return this._bootMode;
    }

    public int getRawBootMode_PROP() {
        return this._rawBootMode;
    }

    public short getRmoSize_PROP() {
        return this._rmoSize;
    }

    public Boolean getIsDefaultProfile_PROP() {
        return this._isDefaultProfile;
    }

    public String getState_PROP() {
        return this._state;
    }

    public String getOpPanelValue_PROP() {
        return this._opPanelValue;
    }

    public CIMObjectPath getCimObjectPath_PROP() {
        return this._cimObjectPath;
    }

    public Hashtable getCachedProperties() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("name", this._name);
        if (this._bootMode != null) {
            hashtable.put("bootMode_PROP", this._bootMode);
        }
        if (this._state != null) {
            hashtable.put("state_PROP", this._state);
        }
        if (this._isDefaultProfile != null) {
            hashtable.put("isDefaultProfile_PROP", this._isDefaultProfile);
        }
        return hashtable;
    }

    public static String getClassName() {
        return HSCResourceBundleUtil.getMessage("ProfileBundle", "PROFILE", "Profile");
    }

    public static void copyProfile(CIMObjectPath cIMObjectPath, String string) throws Throwable, CIMException {
        String[] stringArray;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        MOClass mOClass = null;
        String string6 = null;
        String string7 = null;
        try {
            mOClass = MObjectImpl.getMOClassProxy((String)"com.ibm.hsc.websm.profile.ProfileMObject");
            string6 = mOClass.getHost().getName();
            stringArray = ProfileInfo.getKey(cIMObjectPath);
            int n = stringArray.indexOf("~");
            int n2 = stringArray.indexOf("~", n + 1);
            String string8 = stringArray.substring(0, n);
            String string9 = stringArray.substring(n2 + 1, stringArray.lastIndexOf("~"));
            int n3 = string8.indexOf("*");
            String string10 = string8.substring(n3 + 1);
            string3 = CECInfo.getCecUserDefName(string6, string10);
            string4 = LPARInfo.getLparUserDefName(string6, string8);
            string5 = ProfileInfo.getProfUserDefName(string9, string8);
            string2 = HSCLogUtils.getUserName((MOClass)MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.profile.ProfileMObject"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            string7 = ProfileInfo.copyProfile(mOClass.getHost().getName(), cIMObjectPath, string);
        }
        catch (Throwable throwable) {
            try {
                String[] stringArray2 = new String[]{string5, string3, string4, string};
                HSCLogUtils.logSystemEvent((short)2053, "Copy of profile " + string5 + " of partition " + string4 + " on the system " + string3 + " to profile " + string + " by " + string2 + " failed", stringArray2, string2);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            stringArray = new String[]{string5, string4, string3, string};
            HSCLogUtils.logSystemEvent((short)2052, "Copy of profile " + string5 + " of partition " + string4 + " on the system " + string3 + " to profile " + string + " by " + string2 + " succeeded", stringArray, string2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stringArray = ProfileInfo.getProfileAttribute(null, mOClass.getHost().getName(), string7);
        mOClass.createNewMObject((Hashtable)stringArray, null);
    }

    public static void DeleteProfileMObject(Vector vector) throws Throwable {
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(((MOXReference)enumeration.nextElement()).getKey());
        }
        MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.profile.ProfileMObject");
        DefSysEventSupport defSysEventSupport = (DefSysEventSupport)mOClassImpl.getEventSupport();
        defSysEventSupport.fireMOEvents(vector2, "ODE", (Object)new MOState(null, "deleted"));
        Enumeration enumeration2 = vector2.elements();
        while (enumeration2.hasMoreElements()) {
            mOClassImpl.removeMObject((String)enumeration2.nextElement());
        }
    }

    public static String deleteProfile(Vector vector, Boolean bl) throws Throwable, CIMException {
        String string = "";
        String string2 = "";
        MOXContainerObj mOXContainerObj = null;
        MObjectImpl mObjectImpl = null;
        DefSysEventSupport defSysEventSupport = null;
        DefSysEventSupport defSysEventSupport2 = null;
        String string3 = "";
        String string4 = null;
        MOClass mOClass = MObjectImpl.getMOClassProxy((String)"com.ibm.hsc.websm.profile.ProfileMObject");
        string4 = mOClass.getHost().getName();
        MOClassImpl mOClassImpl = MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.profile.ProfileMObject");
        defSysEventSupport2 = (DefSysEventSupport)mOClassImpl.getEventSupport();
        try {
            string3 = HSCLogUtils.getUserName((MOClass)MObjectImpl.getMOClassImpl((String)"com.ibm.hsc.websm.profile.ProfileMObject"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            mOXContainerObj = (MOXContainerObj)enumeration.nextElement();
            mObjectImpl = mOClassImpl.getMObjectImpl(mOXContainerObj.getMOXReference());
            CIMObjectPath cIMObjectPath = (CIMObjectPath)mOXContainerObj.getPropertyValue("cimObjectPath_PROP");
            String string5 = mOXContainerObj.getName();
            String string6 = "";
            String string7 = "";
            try {
                stringArray = ProfileInfo.getKey(cIMObjectPath);
                int n = stringArray.indexOf("~");
                int n2 = stringArray.indexOf("~", n + 1);
                String string8 = stringArray.substring(0, n);
                int n3 = string8.indexOf("*");
                String string9 = string8.substring(n3 + 1);
                string6 = CECInfo.getCecUserDefName(string4, string9);
                string7 = LPARInfo.getLparUserDefName(string4, string8);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                block14: {
                    try {
                        if (bl.booleanValue()) break block14;
                        ProfileInfo.deleteProfile(mOClass.getHost().getName(), cIMObjectPath);
                    }
                    catch (Throwable throwable) {
                        String[] stringArray2;
                        try {
                            stringArray2 = new String[]{string5, string6, string7};
                            HSCLogUtils.logSystemEvent((short)2055, "Deletion of profile " + string5 + " of partition " + string7 + " on the system " + string6 + " by " + string3 + " failed", stringArray2, string3);
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        stringArray2 = HSCLogUtils.getErrMsg(throwable);
                        if (stringArray2 == null) {
                            stringArray2 = HSCResourceBundleUtil.getMessage("ProfileBundle", "DELETE_PROFILE_ERR_MSG");
                        }
                        string = string + string5 + ": " + (String)stringArray2 + "\n";
                        continue;
                    }
                }
                try {
                    stringArray = new String[]{string5, string6, string7};
                    HSCLogUtils.logSystemEvent((short)2054, "Deletion of profile " + string5 + " of partition " + string7 + " on the system " + string6 + " by " + string3 + " succeeded", stringArray, string3);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                string2 = mObjectImpl.getKey();
                mOClassImpl.removeMObject(string2);
                defSysEventSupport = (DefSysEventSupport)mObjectImpl.getEventSupport();
                ProfileMObject._notifyMOEventListeners(defSysEventSupport2, defSysEventSupport, string2, "ODE", null);
            }
            catch (Throwable throwable) {
                string = string + string5 + ": " + HSCResourceBundleUtil.getMessage("ProfileBundle", "DELETE_PROFILE_GUI_ERR_MSG") + "\n";
            }
        }
        return string;
    }

    private MORelationship _getLPARForProfile() {
        MORelationshipImpl mORelationshipImpl;
        block3: {
            mORelationshipImpl = new MORelationshipImpl("child_parent");
            try {
                Vector vector = LPARMObject.getParentsOfProfile(this.getKey());
                if (vector == null || vector.size() <= 0) break block3;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    mORelationshipImpl.addRelatedObject((MOXContainerObj)enumeration.nextElement());
                }
            }
            catch (Throwable throwable) {
                Diag.handleException((Throwable)throwable);
            }
        }
        return MORelationshipImpl.constructProxy((MORelationshipImpl)mORelationshipImpl);
    }

    private static MOState _createProfileMOState(String string, String string2, Boolean bl) {
        String string3 = null;
        if (bl != null && bl.booleanValue()) {
            return new MOState("exp_dir", string, string3, true);
        }
        return new MOState("p_folder", string, string3, true);
    }

    private void _notifyPropChangeListeners(DefSysEventSupport defSysEventSupport, DefSysEventSupport defSysEventSupport2, String string, Object object) throws Throwable {
        if (defSysEventSupport != null) {
            defSysEventSupport.fireMOPropertyChange(this.getKey(), string, null, object);
        }
        if (defSysEventSupport2 != null) {
            defSysEventSupport2.fireMOPropertyChange(string, null, object);
        }
    }

    private static void _notifyMOEventListeners(DefSysEventSupport defSysEventSupport, DefSysEventSupport defSysEventSupport2, String string, String string2, Object object) throws Throwable {
        if (defSysEventSupport != null) {
            defSysEventSupport.fireMOEvent(string, string2, object);
        }
        if (defSysEventSupport2 != null) {
            defSysEventSupport2.fireMOEvent(string2, object);
        }
    }
}

